--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- This library provides generic functions for table manipulation. It provides all its functions inside the `table` table.
--- @class tablelib
table = {}

--- Inserts a given value through BinaryInsert into an array-style `table` `t`, assuming `t` was sorted by `comp`.
--- 
--- If 'comp' is given, then it must be a function that receives two values in `t` and returns `true` when the first is less than the second.
--- i.e., `comp(a,b) == true` would mean `a` is less than `b`.
--- 
--- If you want to sort in reverse order, you may set `comp = function(a, b) return a > b end`.
--- 
--- This function will return the index where `value` was inserted into `t`.
--- @generic valueType
--- @param t valueType[] No description yet available.
--- @param value valueType No description yet available.
--- @param comp? fun(a: valueType, b: valueType): boolean *Optional*. No description yet available.
--- @return number result No description yet available.
function table.bininsert(t, value, comp) end

--- Performs a binary search for a given `value` inside a specified array-style `table` `tbl`.
--- 
--- If the `value` is in `tbl`, then its corresponding `index` will be returned. Otherwise, this function will return `nil`.
--- If `findAll == true`, then this `binsearch` will return the lowest and highest indices that store `value`. (These indices will be equal if there is only one copy of `value` in `tbl`.)
--- 
--- You can optionally provide a `comp` function. If provided, `binsearch` will treat `tbl` as if it had been sorted by `table.sort(tbl, comp)`.
--- 
--- @generic valueType
--- @param tbl valueType[] No description yet available.
--- @param value valueType The value to search for.
--- @param comp? fun(a: valueType, b: valueType): boolean *Optional*. The function used to sort `tbl`. If not provided, then the standard `<` operator will be used.
--- @param findAll? boolean *Default*: `false`. If true,
--- @return integer|nil index An `index` such that `tbl[index] == value`, if such an index exists. `nil` otherwise. If `findAll == true`, this will be the smallest index such that `tbl[index] == value`.
--- @return integer|nil highestMatch If a match was found, and if `findAll == true`, then this will be the largest `index` such that `tbl[index] == vale`. `nil` otherwise.
function table.binsearch(tbl, value, comp, findAll) end

--- Returns a random element from the given table.
--- @generic keyType
--- @generic valueType
--- @param t { [keyType]: valueType } No description yet available.
--- @return valueType value The randomly chosen value.
--- @return keyType key The table key of the chosen value.
function table.choice(t) end

--- This clears all keys and values from a table, but preserves the allocated array/hash sizes. This is useful when a table, which is linked from multiple places, needs to be cleared and/or when recycling a table for use by the same context. This avoids managing backlinks, saves an allocation and the overhead of incremental array/hash part growth.
--- 
--- Please note this function is meant for very specific situations. In most cases it's better to replace the (usually single) link with a new table and let the garbage collection do its work.
--- @param table table The table to clear.
function table.clear(table) end

--- Returns `true` if a `value` is contained in a table `t`, and `false` otherwise.
--- @param t table No description yet available.
--- @param value unknown No description yet available.
--- @return boolean result No description yet available.
function table.contains(t, value) end

--- Shallowly copies a table's contents to a destination table. If no destination table is provided, a new table will be created. Note that sub tables will not be copied, and will still refer to the same data.
--- @generic fromType : table
--- @generic toType : table
--- @param from fromType No description yet available.
--- @param to? toType *Optional*. No description yet available.
--- @return fromType|toType result No description yet available.
function table.copy(from, to) end

--- Copies a table's contents from one table to another, including subtitles. If a non-table key is already defined, it will not be overwritten. Metatables are not copied.
--- @param to table No description yet available.
--- @param from table No description yet available.
function table.copymissing(to, from) end

--- Copies a table's contents. All subtables will also be copied, as will any metatable.
--- @generic tableType : table
--- @param t tableType No description yet available.
--- @return tableType result No description yet available.
function table.deepcopy(t) end

--- Checks if a table is empty.
--- 
--- If `deepCheck == true`, then tables are allowed to have nested subtables, so long as those subtables are empty. e.g., `table.empty({ {}, {} }, true) == true`, while `table.empty({ {}, {} }) == false`.
--- @param t table No description yet available.
--- @param deepCheck? boolean *Default*: `false`. If `true`, subtables will also be checked to see if they are empty.
--- @return boolean result No description yet available.
function table.empty(t, deepCheck) end

--- Checks if one table is equal to another by recursively iterating through the (key, value) pairs of both tables.
--- Unlike the `==` operator, this will return `true` if two distinct tables have contents that compare equal.
--- For example, all of the following assertions pass:
--- ```lua
--- assert(table.equal({1, 2}, {1, 2}))
--- assert({1, 2} ~= {1, 2})
--- assert(table.equal({a = 1, b = {x = 1}}, {a = 1, b = {x = 1}}))
--- ```
--- 
--- @param left table No description yet available.
--- @param right table No description yet available.
--- @return boolean result True if the contents of `left` are equal to the contents of `right`. False otherwise.
function table.equal(left, right) end

--- Creates a new table that results from using `f` to filter out elements of `t`. i.e., `table.filter(t,f)` will consist of only the pairs `k, v` of `t` for which `f(k, v)` was not `false` or `nil`.
--- Any additional arguments will be passed to `f`. For example, `table.filter(t, f, 10)` would call `f(k, v, 10)` on each pair `k, v` of `t`.
--- 
--- !!! warning
---  	Do not use this function on array-style tables, as it will not shift indices down after filtering out elements. Instead, you should use `table.filterarray` on array-style tables.
--- 
--- @generic keyType
--- @generic valueType
--- @param t { [keyType]: valueType } No description yet available.
--- @param f fun(k: keyType, v: valueType, ...): boolean The function to use when filtering values of `t`. (This is sometimes called a predicate function.)
--- @param ... any Additional parameters to pass to `f`.
--- @return { [keyType]: valueType } result The result of using `f` to filter out elements of `t`.
function table.filter(t, f, ...) end

--- Creates a new array-style table that results from using `f` to filter out elements of an array-style table `arr`. i.e., `table.filterarray(arr, f)` 
--- will consist of only the pairs `i, v` of `arr` for which `f(i, v)` was not `false` or `nil`.
--- Any additional arguments will be passed to `f`. For example, `table.filterarray(arr, f, 10)` would call `f(i, v, 10)` on each value pair `i, v` of `arr`.
--- 
--- When an element gets filtered out, the index of subsequent items will be shifted down, so that the resulting table plays nicely with the `#` operator and the `ipairs` function.
--- @generic valueType
--- @param arr valueType[] No description yet available.
--- @param f fun(i: integer, v: valueType, ...): boolean The function to use when filtering values of `t`. (This is sometimes called a predicate function.)
--- @param ... any Additional parameters to pass to `f`.
--- @return valueType[] result The result of using `f` to filter out elements of `t`.
function table.filterarray(arr, f, ...) end

--- Returns the key for a given value, or `nil` if the table does not contain the value.
--- @generic keyType
--- @generic valueType
--- @param t { [keyType]: valueType } No description yet available.
--- @param value valueType No description yet available.
--- @return keyType|unknown|nil key A `key` such that `tbl[key] == value`, if such a key exists. `nil` otherwise.
function table.find(t, value) end

--- Gets a value in a table. If the key doesn't exist in the table, a specified default value will be returned instead.
--- @generic keyType
--- @generic valueType
--- @generic defaultValueType
--- @param t { [keyType]: valueType } No description yet available.
--- @param key keyType The key to use to access the table.
--- @param defaultValue defaultValueType The default value if the key didn't exist in the table.
--- @return valueType|defaultValueType|unknown result No description yet available.
function table.get(t, key, defaultValue) end

--- Gets a value in a table. If the key doesn't exist in the table, a specified default value will be set in the table and returned instead.
--- @generic keyType
--- @generic valueType
--- @generic defaultValueType
--- @param t { [keyType]: valueType } No description yet available.
--- @param key keyType The key to use to access the table.
--- @param defaultValue defaultValueType The default value to set and return if the key didn't exist in the table.
--- @return valueType|defaultValueType|unknown result No description yet available.
function table.getset(t, key, defaultValue) end

--- Returns a copy of `t` with the keys and values flipped.
--- @generic keyType
--- @generic valueType
--- @param t { [keyType]: valueType } No description yet available.
--- @return { [valueType]: keyType } result No description yet available.
function table.invert(t) end

--- Returns an array-style table of all keys in the given table, t. Optionally, it will sort the returned table.
--- @generic keyType
--- @param t { [keyType]: unknown } The table to get keys for.
--- @param sort? boolean|fun(a: keyType, b: keyType): boolean *Optional*. If true, the returned table will be sorted. If a function is passed, the table will be sorted using the given function.
--- @return keyType[] keys An array of all table keys.
function table.keys(t, sort) end

--- Creates a new table consisting of key value pairs `k, f(k, v)`, where `k, v` is a pair in `t`.
--- Any additional arguments will be passed to `f`. For example, `table.map(t, f, 10)` would call `f(k, v, 10)` on each value `v` of `t`.
--- @generic keyType
--- @generic valueType
--- @generic newValueType
--- @param t { [keyType]: valueType } No description yet available.
--- @param f fun(k: keyType, v: valueType, ...): newValueType The function to apply to each element of `t`.
--- @param ... any Additional parameters to pass to `f`.
--- @return { [keyType]: newValueType } result The result of applying `f` to each value in `t`.
function table.map(t, f, ...) end

--- This creates a pre-sized table. This is useful for big tables if the final table size is known and automatic table resizing is too expensive.
--- @param narray number A hint for how many elements the array part of the table will have. Allocates fields for [0, narray].
--- @param nhash number A hint for how many elements the hash part of the table will have.
--- @return table newTable The pre-sized table that was created.
function table.new(narray, nhash) end

--- Removes a `value` from a given `list`. Returns `true` if the value was successfully removed.
--- @generic valueType
--- @param list { [unknown]: valueType } No description yet available.
--- @param value valueType No description yet available.
--- @return boolean result No description yet available.
function table.removevalue(list, value) end

--- Shuffles the table in place using the Fisher-Yates algorithm. Passing in table size as the second argument saves the function from having to get it itself.
--- @param t table No description yet available.
--- @param n? integer *Default*: `#t`. The length of the array.
function table.shuffle(t, n) end

--- Returns the number of elements inside the table. Unlike the length operator (#) this will work with any table.
--- @param t table No description yet available.
--- @return number result No description yet available.
function table.size(t) end

--- Sets a value in a table and returns any previously defined value for that key.
--- @generic keyType
--- @generic valueType
--- @param t { [keyType]: valueType } No description yet available.
--- @param key keyType The key to use to access the table.
--- @param value any The value to set.
--- @return valueType|unknown|nil oldValue The previously defined value at `t[key]`.
function table.swap(t, key, value) end

--- This function performs a DFS over a graph-like table. You can specify the key of the subtable that contains the child nodes.
--- 
--- Each "node" is an object with a children table of other "nodes", each of which might have their own children. For example, a sceneNode is made up of niNodes, and each niNodes can have a list of niNode children. This is best used for recursive data structures like UI elements and sceneNodes etc.
---
--- [Examples available in online documentation](https://mwse.github.io/MWSE/apis/table/#tabletraverse).
--- @generic tableType
--- @param t tableType A table to transverse.
--- @param k? string *Default*: `children`. The subtable key.
--- @return fun(): tableType|any iterator No description yet available.
function table.traverse(t, k) end

--- Returns an array-style table of all values in the given table, t. Optionally, it will sort the returned table.
--- @generic valueType
--- @param t { [unknown]: valueType } The table to get values for.
--- @param sort? boolean|fun(a: valueType, b: valueType): boolean *Optional*. If true, the returned table will be sorted. If a function is passed, the table will be sorted using the given function.
--- @return valueType[] values An array of all table values.
function table.values(t, sort) end

--- This function is used for calculating relative access into an array, such that accessing an element one past the array's size will instead return the position of the first element. Providing an index one before the start (note that this is `0`, not `-1`) will instead give the index to the last element in the array.
--- @param t table The table whose size will determine the new wrapped index.
--- @param index number The initial provided index. If this is before or after the array, it will be cycled around.
--- @return number index No description yet available.
function table.wrapindex(t, index) end

